# DynamicPreview - (c) 2014-2017 Juxtaposition. All Rights Reserved.
# This code cannot be redistributed without permission from juxtaposition.jp
# For more information, consult your DynamicPreview license.
#

package DynamicPreview::L10N::ja;

use strict;
use base 'DynamicPreview::L10N::en_us';
use vars qw( %Lexicon );

## The following is the translation table.

%Lexicon = (
    'DynamicPreview(Trial)' => 'DynamicPreview（評価版）',
    'DynamicPreview Pro(Trial)' => 'DynamicPreview Pro（評価版）',
    'This plugin allows you to preview an entry/page/template/content data dynamically.' => '動的な記事／ページ／テンプレート／コンテンツデータのプレビュー機能を提供します。',
    'Dynamic preview' => '動的プレビュー',
    'Enable' => '有効にする',
    'SSI Include' => 'SSIインクルード',
    'Only the include virtual command is supported.' => 'include virtualコマンドのみサポートされます。',
    'Document Root' => 'ドキュメントルート',
    'Specify the document root for this website. If you set a blank, the parent site setting is used.' => 'ウェブサイトのドキュメントルートを指定します。指定されない場合は親サイトの設定に従います。',
    'Specify the document root for this website.' => 'ウェブサイトのドキュメントルートを指定します。',
    'PC Preview' => 'PCプレビュー',
    'Base URL' => 'ベースURL',
    'Insert the base tag when the base URL is specified. If the template name is omitted, the base url applies to all the template. If you set a blank, the parent site setting is used.' => 'ベースURLが指定された場合、baseタグを挿入します。テンプレート名が省略された場合、全てのテンプレートに同じベースURLを適用します。指定されない場合は親サイトの設定に従います。',
    'Insert the base tag when the base URL is specified. If the template name is omitted, the base url applies to all the template.' => 'ベースURLが指定された場合、baseタグを挿入します。テンプレート名が省略された場合、全てのテンプレートに同じベースURLを適用します。',
    'Insert the base tag with the specified URL. If the template name is omitted, the base URL applies to all the template. If you set a blank, the Site URL is used.' => '指定したURLでbaseタグを挿入します。テンプレート名が省略された場合、全てのテンプレートに同じベースURLを適用します。指定されない場合はサイトURLを使用します。',
    'Insert the base tag when the base URL is specified. If the template name is omitted, the base URL applies to all the template. If you set a blank, the Site URL is used.' => '指定されたURLでbaseタグを挿入します。テンプレート名が省略された場合、全てのテンプレートに同じベースURLを適用します。指定されない場合はサイトURLが使用されます。',
    # not used
    'Convert URL' => 'URL変換',
    'Convert relative URL to absolute URL.' => '相対URLを絶対URLに変換します。',
    #
    'Preview Template' => 'プレビューテンプレート',
    'URL Replacement' => 'URL置換',
    'Replace URL by the specified string. Separates the pattern and the replacement string with a comma, specifies one per line. If you set a blank, the parent site setting is used.' => '指定された文字列でURLを置換します。検索対象と置換文字列はカンマで区切り、1行に1つ指定してください。指定されない場合は親サイトの設定に従います。',
    'Replace URL by the specified string. Separates the pattern and the replacement string with a comma, specifies one per line.' => '指定された文字列でURLを置換します。検索対象と置換文字列はカンマで区切り、1行に1つ指定してください。',
    'PATTERN,REPLACEMENT' => '検索対象,置換文字列',
    'BASE_URL,TEMPLATE_NAME' => 'ベースURL,テンプレート名',
    'Creating preview...' => 'プレビュー生成中...',
    'Failed to create preview.' => 'プレビューの生成に失敗しました。',
    'Replace any strings in the HTML source. Separates the pattern and the replacement string with a comma, specifies one per line. If you set a blank, the parent site setting is used. If the template name is omitted, the replacement applies to all the template.' => '指定された文字列でHTMLソースを置換します。検索対象と置換文字列はカンマで区切り、1行に1つ指定してください。指定されない場合は親サイトの設定に従います。テンプレート名が省略された場合、全てのテンプレートに対して置換が適用されます。',
    'Replace any strings in the HTML source. Separates the pattern and the replacement string with a comma, specifies one per line. If the template name is omitted, the replacement applies to all the template.' => '指定された文字列でHTMLソースを置換します。検索対象と置換文字列はカンマで区切り、1行に1つ指定してください。テンプレート名が省略された場合、全てのテンプレートに対して置換が適用されます。',
    'PATTERN,REPLACEMENT,TEMPLATE_NAME' => '検索対象,置換文字列,テンプレート名',
    'Replace String' => '文字列置換',
    'Unsaved data is not displayed in index/archive template preview.' => '保存されていないデータは、インデックス／アーカイブテンプレートのプレビューに反映されません。',
    #
    'Index/Archive Template IDs' => 'インデックス／アーカイブテンプレートID',
    'Specify the template IDs one per line to preview the index/archive templates along with the entry.'
        => '記事と一緒にインデックス／アーカイブテンプレートをプレビューする場合は、テンプレートIDを1行に1つ指定してください。',
    'Index/Archive Template IDs for Content Data' => 'コンテンツデータ用インデックス／アーカイブテンプレートID',
    'Specify the template IDs one per line to preview the index/archive templates along with the content data.'
        => 'コンテンツデータと一緒にインデックス／アーカイブテンプレートをプレビューする場合は、テンプレートIDを1行に1つ指定してください。',
    'TEMPLATE_ID' => 'テンプレートID',
    'A link to preview the entry will be sent in the notification.' => 'プレビューのためのリンクを送信します。',
    'No preview URL was provided' => 'プレビューURLが指定されていません。',
    #
    'Preview: [_1] - [_2]' => 'プレビュー通知: [_1] - [_2]',
    '([_1]) Request for check - [_2]' => '([_1]) 内容確認のお願い - [_2]',
    'Send mail' => 'メール送信',
    'Edit' => '編集',
    'Save Preview...' => 'プレビュー保存...',
    'As PDF' => 'PDF形式で保存',
    'As JPEG' => 'JPEG形式で保存',
    'Send a mail' => 'メールの送信',
    'Subject' => '件名',
    'Include' => '含める',
    'Draft entry/page/content data' => '未公開記事／ページ／コンテンツデータ',
    'Include draft entry/page/content data in index/archive template preview.' => '未公開記事／ページ／コンテンツデータをインデックス／アーカイブテンプレートのプレビューに含めます。',
    'Future entry/page/content data' => '日時指定記事／ページ／コンテンツデータ',
    'Include future entry/page/content data in index/archive template preview.' => '日時指定記事／ページ／コンテンツデータをインデックス／アーカイブテンプレートのプレビューに含めます。',
    'Default mail subject' => 'デフォルトメール件名',
    'Specify the default mail subject. The subject can be changed at the mail dialog.' => 'デフォルトのメール件名を指定します。件名はメール送信ダイアログでも変更できます。',
    'Mail body template' => 'メール本文テンプレート',
    'Specify the mail body template.' => 'メール本文のテンプレートを指定します。',
    'You must enter the subject.' => '件名を入力してください。',
    'No email template.' => 'メールテンプレートが設定されていません。',
    'Preview role' => 'プレビューロール',
    'Create' => '作成する',
    'Successfully created preview role.' => 'プレビューロールを作成しました。',
    'Failed to create preview role.' => 'プレビューロールの作成に失敗しました。',
    'Can preview entries, pages, templates and send mail.' => '記事／ウェブページ／テンプレートのプレビューとメール送信が行えます。',
    #
    'Entry ID or category ID was not provided' => '記事またはカテゴリのIDが指定されていません。',
    'Address not found.' => 'あて先が見つかりません。',
    "Preview this category's archive" => 'このカテゴリのアーカイブをプレビュー',
    #
    'Exclude Archive Template IDs' => '除外するアーカイブテンプレートID',
    'Specify the template IDs one per line to exclude from the preview of the archive templates along with the entry.'
        => '記事と一緒にプレビューしたくないアーカイブテンプレートがある場合は、テンプレートIDを1行に1つ指定してください。',
    'Exclude Archive Template IDs for Content Data' => 'コンテンツデータ用除外するアーカイブテンプレートID',
    'Specify the template IDs one per line to exclude from the preview of the archive templates along with the content data.'
        => 'コンテンツデータと一緒にプレビューしたくないアーカイブテンプレートがある場合は、テンプレートIDを1行に1つ指定してください。',
    #
    'Load the latest revision if no revision is specified.' => '更新履歴が指定されていない場合、最新の更新履歴を読み込む',
    #
    'Please select save format.' => '保存形式を選択してください。',
    'Basic Auth for saving preview' => 'プレビュー保存時のベーシック認証',
    'Specify the authentication information required to access the image URL with basic authentication when saving the preview. Specify one set of hostname, username and password per line, separated by commas.'
        => 'プレビュー保存時にベーシック認証がかかっている画像URLへアクセスするために必要な認証情報を指定します。ホスト名、ユーザ名、パスワードをカンマで区切り、1行に1セットずつ指定してください。',
    'HOSTNAME,USERNAME,PASSWORD' => 'ホスト名,ユーザ名,パスワード',
    #
    'Invalid request: Saved content data is required.' => '不正な要求です: 保存されたコンテンツデータが必要です。',
    'Invalid request: Saved category is required.' => '不正な要求です: カテゴリが必要です。',
    'No category found for archive template.' => 'アーカイブテンプレートに対応するカテゴリが見つかりません。',
    'Invalid request: Archive type is required.' => '不正な要求です: アーカイブタイプが必要です。',
    'Invalid request: Template map is required.' => '不正な要求です: テンプレートマップが必要です。',
    'Invalid request: Template is required.' => '不正な要求です: テンプレートが必要です。',
    'Failed to build archive template: [_1]' => 'アーカイブテンプレートの構築に失敗しました: [_1]',
    'No output from _rebuild_content_archive_type.' => '_rebuild_content_archive_type から出力がありません。',
    #
    'The template [_1] is not found.' => 'テンプレート[_1]が見つかりません。',
    'The template [_1] is not associated with the content type [_2].' => 'テンプレート[_1]はコンテンツタイプ[_2]に関連付けられていません。',
);

1;
