<?php
/**
 * SkeletonCart
 * (c) 2017 Juxtaposition Inc. All Rights Reserved.
 * (c) 2017 Curlybracket, Inc. All Rights Reserved.
 * This code cannot be redistributed without permission from the copyright holder.
 * For more information, consult your SkeletonCart license.
 **/

namespace GroupPostage;

class Plugin extends \App\Plugin
{

    public function __construct($key)
    {
        parent::__construct($key);
        $this->initCallback();
    }

    public function initCallback()
    {
        \App::addCallback('postInit', array($this, 'postInit'));
    }

    public function postInit()
    {
        \App::register('postage', '\GroupPostage\Postage',
            array(\App::config()->getPostageTable(), \App::config()->getFreePostagePrice())
        );
    }
}

\App::addPlugin(new Plugin('GroupPostage'));
