<?php
/**
 * SkeletonCart
 * (c) 2017 Juxtaposition Inc. All Rights Reserved.
 * (c) 2017 Curlybracket, Inc. All Rights Reserved.
 * This code cannot be redistributed without permission from the copyright holder.
 * For more information, consult your SkeletonCart license.
 **/

namespace GroupPostage;


class Postage extends \App\Postage
{
    protected $fileName;
    protected $config;
    protected $currentGroupId;

    public function __construct($table, $freePostagePrice)
    {
        parent::__construct($table, $freePostagePrice);

        $this->fileName = __DIR__ . "/Config.php";

        if (!is_readable($this->fileName)) {
            throw new \RuntimeException("グループ別送料設定が読み込めません。");
        }
        $this->config = include $this->fileName;

        if (!isset($this->config['primaryGroupId'])) {
            throw new \RuntimeException("primaryGroupIdが設定されていません。");
        }
        if (!isset($this->config['groupTable']) || !is_array($this->config['groupTable'])) {
            throw new \RuntimeException("itemIdsが設定されていません。");
        }
    }

    public function groupTable()
    {
        return $this->config['groupTable'];
    }

    public function primaryGroupId()
    {
        return $this->config['primaryGroupId'];
    }

    public function table()
    {
        error_log(__METHOD__);
        if (!isset($this->currentGroupId)
            || array_key_exists($this->currentGroupId, $this->groupTable()) === false
        ) {
            return parent::table();
        }
        return $this->config['groupTable'][$this->currentGroupId];
    }

    public function calculate(\App\Cart $cart, \App\Slip $slip)
    {
        if ($cart->count() == 0) {
            return 0;
        }
//		$groupId = $cart->sameGroupIdOnly() ? $cart[0]->groupId() : $this->primaryGroupId();
        $groupId = $cart[0]->groupId();
        $mixed = array_reduce($cart->items(), function ($flag, $item) use ($groupId) {
            return ($item->groupId() !== $groupId) ? $flag + 1 : $flag;
        }, 0);

        if ($mixed) {
            $groupId = $this->primaryGroupId();
        }

        if (isset($groupId) && array_key_exists($groupId, $this->groupTable())) {
            $this->currentGroupId = $groupId;
        } else {
            $this->currentGroupId = null;
        }

        $postage = parent::calculate($cart, $slip);
        return $postage;

    }

}

